package kr.co.joytune.dpush;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;

public class DPushReceiver extends BroadcastReceiver {

	private static final String TAG = DPushReceiver.class.getSimpleName();

	public static final String ACTION_DPUSH_RESTART = "kr.co.joytune.dpush.restart";

	@Override
	public void onReceive(Context context, Intent intent) {
		String action = intent.getAction();
		Log.d(TAG, action);

		/* 서비스 재시작 */
		if (action.equals(DPushReceiver.ACTION_DPUSH_RESTART)) {
			Log.d(TAG, "Service dead, but resurrection");
			Intent i = new Intent(context, DPushService.class);
			context.startService(i);
		}

		/* 스마트폰 부팅완료 */
		if (action.equals(Intent.ACTION_BOOT_COMPLETED)) {
			Log.d(TAG, "ACTION_BOOT_COMPLETED");
			Intent i = new Intent(context, DPushService.class);
			context.startService(i);
		}

		/* 네트웍 변경 */
		if (action.equals(ConnectivityManager.CONNECTIVITY_ACTION)) {
			ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
			NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
			if (activeNetInfo != null) {
				Intent i = new Intent(context, DPushService.class);
				context.startService(i);
			}
		}
	}
}